<?php

    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/SocialSharer.php";
    include "gUtil/GestoreTraduzioni.php";
    include "template/stile.php";
    include "classi/GeneratoreUrl.php";
    include "classi/GestoreJavascript.php";
    include "classi/ecommerce/Carrello.php";
    include "template/include/includeClassiTemplate.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb          = new DbManager($costantiDatabase);
    $gestoreJavascript = new GestoreJavascript();
        
    $impostazioni          = recuperaImpostazioni($geecomDb);
    $configurazioneAspetto = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto","si","selezionataCms");
    $inclusioni            = recuperaInclusioni($geecomDb);
    
    // recupera lo stile scelto, la variabile aspettiSito è contenuta nel file stile.php
    $aspettoSito = $aspettiSito[$impostazioni["aspettoSito"]];

    session_start();
    if(isset($_SESSION["carrello"])) { //se il campo passato in input è effettivamente un numero allora fa la query
        $carrello = new Carrello($geecomDb,$_SESSION["carrello"]);
        $carrello->caricaDatiDalDatabase();
        if(isset($_SESSION["geecomUser_id"])) {
            $sessioneUtente = $_SESSION["geecomUser_id"];
            $carrello->setIdUtente($_SESSION["geecomUser_id"]);
        }
        else {
            $sessioneUtente = 0;
        }
    }
    else {
	header("Location: index.php"); //se non è presente una sessione del carrello deve essere rediretto in home page
	exit();
    }

    $ordine = $geecomDb->leggiSingolaRiga("geecEc_ordini",$_SESSION["idOrdine"]);
    $nomeCognome = explode(" ",$ordine["destinatario"]);

    $nome    = $nomeCognome[0];
    $email   = $ordine["email"];
    $via     = $ordine["indirizzoSpedizione"];
    $citta   = $ordine["citta"];
    $capSpedizione = $ordine["capSpedizione"];
    $spedizione = $ordine["tipoSpedizione"];
    $tipoPagamento = $ordine["tipoPagamento"];
    $tipoRicevuta = "";
    
    $lingua = "italiano"; //Attualmente i prodotti multilingua non sono supportati
    $gestoreTraduzioni  = new GestoreTraduzioni("localizzazione", array($lingua));
        
    $datiCookie    = $geecomDb->leggiSingolaRiga("geecB_leggeCookie",$lingua,"lingua");
    $profiliSocial = $geecomDb->leggiSingolaRiga("geec_profiliSocial",1);
    
    $impostazioniEmail     = recuperaImpostazioniEmail($geecomDb);
    $impostazioniEcommerce = $geecomDb->leggiSingolaRiga("geecEc_impostazioni",1);
    $impostazioniPagamenti = $geecomDb->leggiSingolaRiga("geecEc_impostazioniPagamenti",1);
 
    // Le mail di conferma vengono inviate solo se l'ordine è pagato oppure è stato selezionato un pagamento non istantaneo
    if($ordine["stato"]=="pagato" || $tipoPagamento=="bonifico" || $tipoPagamento=="Carta prepagata" || $tipoPagamento=="Pagamento alla consegna") {
        
        //se ha creato l'utente invia una mail di avviso con il link per il login
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        $headers .= "From: {$impostazioniEmail["nomeMittente"]} <{$impostazioniEmail["emailMittente"]}>" . "\r\n";

        $oggetto = "Conferma acquisto";
        $link = $impostazioniEmail['urlPiattaforma'];
        $messaggio = "Ciao $nome, <br><br> ti confermiamo l'avvenuto acqusito dei seguenti prodotti:<br><br>";
        $messaggio .= $carrello->stampaSommarioCarrelloPerEmail();
        $messaggio .= "<br><br><strong>Totale: ".$carrello->getImportoTotale()." €</strong>";
        if($tipoPagamento=="bonifico") {
            $messaggio .=  $impostazioniPagamenti["dettagliContoCorrente"]."<br>";
        }
        if($tipoPagamento=="prepagata") {
            $messaggio .=  $impostazioniPagamenti["dettagliPrepagata"]."<br>";
        }
        if($tipoPagamento=="Pagamento alla consegna") {
            $messaggio .=  $impostazioniPagamenti["dettagliPagamentoConsegna"]."<br>";
        }

        $datiEmail = $geecomDb->leggiSingolaRiga("geec_templateEmail",1);

        $corpoMail = str_replace("testo_da_inserire",$messaggio,$datiEmail['corpoMail']);
        $messaggioHTML = "<!doctype html>
                <html>
                  <head>
                    <meta name=\"viewport\" content=\"width=device-width\" />
                    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                    <title>$oggetto</title>
                    <style>
                        {$datiEmail['css']}
                    </style>
                  </head>
                  <body class=\"\">
                </body>
                $corpoMail
                {$datiEmail['footerMail']}";
        mail($email, $oggetto, $messaggioHTML, $headers);
        
        // invio email nuovo acquisto alla mail impostata per ricevere gli ordini

        $messaggio = "{$ordine["destinatario"]} ha effettuato un nuovo acqusito sul tuo sito {$impostazioni["titoloSito"]}:<br><br>";
        $messaggio .= $carrello->stampaSommarioCarrelloPerEmail();
        $messaggio .= "<br><strong>Totale: ".$carrello->getImportoTotale()." €</strong>";
        if($tipoPagamento=="bonifico") {
            $messaggio .=  $impostazioniPagamenti["dettagliContoCorrente"]."<br>";
        }
        if($tipoPagamento=="prepagata") {
            $messaggio .=  $impostazioniPagamenti["dettagliPrepagata"]."<br>";
        }
        if($tipoPagamento=="Pagamento alla consegna") {
            $messaggio .=  $impostazioniPagamenti["dettagliPagamentoConsegna"]."<br>";
        }

        $corpoMailAdmin         = str_replace("testo_da_inserire",$messaggio,$datiEmail['corpoMail']);
        $messaggioHTMLmailAdmin = "<!doctype html>
                <html>
                  <head>
                    <meta name=\"viewport\" content=\"width=device-width\" />
                    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                    <title>$oggetto</title>
                    <style>
                        {$datiEmail['css']}
                    </style>
                  </head>
                  <body class=\"\">
                </body>
                $corpoMailAdmin
                {$datiEmail['footerMail']}";

        mail($impostazioniEcommerce["mailOrdini"], "Nuovo ordine sul tuo sito {$impostazioni["titoloSito"]}", $messaggioHTMLmailAdmin, $headers);
        
        error_log("mail amministratore inviata");
    }
    
?>
<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Acquisto effettuato</title>
    <?php 
	include "include/includeCssBase.php"; 
    ?>

    <!-- Stile utente personalizzato -->
    <link rel="stylesheet" type="text/css" href="template/stile.css">
</head>

<body class="<?php echo $aspettoSito["body"]; ?> <?php echo(($impostazioni["attivaBarraSuperiore"]=="si") ? "extraspace" : ""); ?>">

    <div class="page-wrapper">
        <?php
            include"template/include/aspetto/{$aspettoSito["cartellaMenu"]}/menuPrincipale.php";
        ?>
        
        <!-- Inizio contenuto pagina -->        
        <main role="main">
            <section class="py-4 bg-light shopping-cart">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <nav>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                                    <li class="breadcrumb-item active">Acquisto effettuato </li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                    <div class="row">
                        <div id="colonna-principale" class="col-12">
                            <?php 
                            
                               // La conferma di acquisto effettuato viene data solo se l'ordine è pagato oppure è stato selezionato un pagamento non istantaneo
                            	if($ordine["stato"]=="pagato" || $tipoPagamento=="bonifico" || $tipoPagamento=="Carta prepagata" || $tipoPagamento=="Pagamento alla consegna") {
                            ?>
		                    <h2><i class="far fa-check-circle mr-2 text-success"></i>Acquisto effettuato</h2>
                            <?php	
	                        // scelgo le informazioni di pagamento da inserire
	                        if($tipoPagamento=="bonifico") {
	                            $informazioniSupplementari = $impostazioniPagamenti["dettagliContoCorrente"]."<br>";
	                        }
	                        else if($tipoPagamento=="Carta prepagata") {
	                            $informazioniSupplementari = $impostazioniPagamenti["dettagliPrepagata"]."<br>";
	                        }
	                        else if($tipoPagamento=="Pagamento alla consegna") {
	                            $informazioniSupplementari = $impostazioniPagamenti["dettagliPagamentoConsegna"]."<br>";
	                        }
	                        else {
	                            $informazioniSupplementari = "";
	                        }
	                        $carrello->stampaSommarioCarrello($tipoPagamento,$informazioniSupplementari);
                            	}
				else {
				?>
                                    <h2><i class="far fa-check-circle mr-2 text-warning"></i>Acquisto non effettuato</h2>
                                    <a class="btn btn-success text-center" href="paginaPagamento.php">Clicca qui per completare il tuo acquisto</a>
				<?php
				}
                            ?>
                        </div>
                    </div>
                </div>
            </section>
        </main>
    </div>

    <?php 
    
        include "template/include/aspetto/{$aspettoSito["cartellaFooter"]}/footer.php";

        // contiene la modal sulla legge dei cookie, la ricerca fullscreen ed eventuali
        // aggiunte del tema
        include"template/include/elementiAggiuntiviTemplate.php";

	UtilTemplate::stampaScrollTop();
        include "include/includeJsBase.php";
    ?>
</body>

</html>
<?php 
    // l'ordine è stato completato, rimuovo la sessione ordine
    unset($_SESSION["carrello"]);
    unset($_SESSION["idOrdine"]);
